#! /bin/bash

# loop for generating SDMP
r_idx=0
for ((idx=0; idx<${#GNN_target_seed[@]}; ++idx)); do
    data_time=`date +"%Y-%m-%d %T" | sed -r 's/ /_/g'`
    cur_result_path=${host_name}_${data_time}
    set -x
    taskset -c ${cpu_list[$r_idx]} python ../main_gen_SDMP.py --data ../dataset --config ${SDMP_config} --device "cuda:${gpu_list[$r_idx]}" --result "${SDMP_root_result_path}/${cur_result_path}" --gnn $GNN_target_path_root${GNN_target_seed[$idx]} > /dev/null &
    pids[$r_idx]=$!
    set +x
    sleep 1

    r_idx=$((r_idx+1))
    if [ $r_idx -ge $pool_size ];then
        for pid in ${pids[*]}; do
            wait $pid
        done
    r_idx=0
    fi
done 

for pid in ${pids[*]}; do
    wait $pid
done
